.cseg
; ***********************************************************************************************
;	Interruptbereich:			(c) 2024 by DC7GB unter: BY-NC-SA 4.0
; ***********************************************************************************************


;-----------------------------------------------------------------------------------------------
; ADC-Ereignis alle 1/40000 Sekunden						(alle 25s)
;-----------------------------------------------------------------------------------------------

ADC_RDY:	pushsr
; -------------
; PDM-Ausgabe:
		cli
		out	TC1H,akku1		; letzten ADC-Wert an
		out	OCR1B,akku0		; ...den PDM bergeben
		sei
; ---------------------------------------------
; neuen ADC-Wert abholen:

.ifndef	_NOPWM
		in	akku0,ADCL		; lade neuen ADC-Wert (L)
		in	akku1,ADCH		; ...und (H) fr nchsten IRQ
.else
		clr	akku0			; moduliere den
		clr	akku1			; ...PWM nicht
.endif
		mov	XL,akku0		; Kopie des Samples fr
		mov	XH,akku1		; ...Overflow-Detektor in MAIN
		ldi	temp,low(OFFSET)	; bringe bipolaren
		add	akku0,temp		; ...ADC-Bereich
		ldi	temp,high(OFFSET)	; ...in den absoluten
		adc	akku1,temp		; ...PDM-Bereich
; Mode-Select:
		sbic	PINB,J3			; 1kHz Testsignal ausgeben?
		rjmp	adc_end			; nein...

; ---------------------------------------------
; Generatorsektion (nur wenn J3 gesteckt ist):

.ifdef	_RECHTECK
		dec	square			; Periode abgelaufen?
		brpl	rec_next		; nein...
		ldi	square,(SINTABEND-SINTAB)/2	; Zher auf Maximum einstellen
REC_NEXT:	cpi	square,(SINTABEND-SINTAB)/4	; Periodenhlfte unterschritten?
		brcc	rec_l			; nein...
REC_H:		ldiw	X,766			; lade H-Pegel (75% Modulation)
		rjmp	recout
;
REC_L:		ldiw	X,256			; lade L-Pegel (25% Modulation)
RECOUT:		mov	akku0,XL		; stelle nchsten
		mov	akku1,XH		; ...Mod-Pegel bereit
.else

; Sinus-Sample:
		ldsw	Z,sinp			; Lade Zeiger in Sinus-Tabelle
		lpm	akku0,Z+		; L-Byte und
		lpm	akku1,Z+		; ...H-Byte laden
		lds	temp,sinanz		; Restanzahl am
		dec	temp			; ...Ende angekommen?
		brne	sintabset		; nein...
		rcall	test_toggle		; Referenzsignal an TEST erzeugen
		ldi	temp,SINSAMP		; Tabelle neu aufsetzen
		ldiw	Z,(2*SINTAB)		; ...und Zeiger auf Anfang
SINTABSET:	stsw	sinp,Z			; ...der Sinus-Tabelle stellen
		sts	sinanz,temp		; Restanzahl speichern
.endif
; -------------
ADC_END:	popsr
		reti



;-----------------------------------------------------------------------------------------------
; OCRA-Interrupt fr ADC und 10ms-Systemtimer alle 25s:
;-----------------------------------------------------------------------------------------------

TIM0_COMPA:	pushsr
; -------------
; Timer:
		dec	t25us			; 1ms erreicht?
		brne	tim0_end		; nein...
		ldi	t25us,40		; lade neues Intervall
; 1ms:
		dec	t10ms			; 10ms erreicht?
		brne	tim0_end		; nein...
		ldi	t10ms,10		; lade neues Intervall
; 10ms:
		sbr	flags0,(1<<TIMER)	; setze Marke fr MAIN
		inc	tics			; durchlaufender 10ms-Timer
		decram	t10_led			; Anzeige-Verlngerung
		decram	t10_start		; Start-Blinktimer
; -------------
TIM0_END:	popsr
		reti

